﻿#include "precompiled.h"
#include "common.h"
#include "MeshRenderer.h"

#include "Entity.h"
#include "Mesh.h"
#include "Material.h"

using namespace DirectX;

namespace RTCam {

MeshRenderer::MeshRenderer(const shared_ptr<Entity>& entity) :
	Component(entity),
	m_meshWarningPrinted(false),
	m_mesh(),
	m_material()
{
}


MeshRenderer::~MeshRenderer(void)
{
}

void MeshRenderer::UpdateCBuffer()
{
	auto entity = m_entity.lock();
	ASSERT_MSG(entity != nullptr, "A transform had no owning entity");

	auto material = m_material;
	if(material != nullptr) {
		entity->m_modelCBufferData.Emission = material->m_emission;
	} else {
		entity->m_modelCBufferData.Emission = XMFLOAT3A(0, 0, 0);
	}
}

void MeshRenderer::SetMesh( const shared_ptr<Mesh>& mesh )
{
	// Reset the warning status
	m_meshWarningPrinted = false;
	m_mesh = mesh;
}

void MeshRenderer::SetMaterial( const shared_ptr<Material>& material )
{
	m_material = material;
}

} // end namespace